create or replace function createtable() 
returns void as 
$body$ 
declare
    msgfinal text := 'foi criada';
begin 
    if not exists (select 1 from information_schema.columns where table_name = 'pdv_vd_crm_bonus_totals') then 
		create table if not exists public.pdv_vd_crm_bonus_totals (
			cd_emp bigint default 0 not null,
			cd_filial bigint default 0 not null,
			cd_cx bigint default 0 not null,
			cd_vd bigint default 0 not null,
			dt_vd timestamp not null,
			sts_envio_crm_bonus int default 0 not null,
			descricao_erro varchar(100) default '' null,
			CONSTRAINT pdv_vd_crm_bonus_totals_pkey primary key (cd_emp, cd_filial, cd_cx, cd_vd)
		);
    else    
        msgfinal := 'a tabela já existe';
    end if;

    raise notice 'tabela pdv_vd_crm_bonus_totals %', msgfinal::varchar;

end; 
$body$ 
language plpgsql volatile 
cost 100; 
alter function createtable() owner to postgres;
select createtable(); 
drop function createtable();